-- tools tab
setDefaultTab("pra War")

UI.Label("para editar ou criar novos macros"):setColor("pink")

-- allows to test/edit bot lua scripts ingame, you can have multiple scripts like this, just change storage.ingame_lua
UI.Button("Ingame macro editor", function(newText)
  UI.MultilineEditorWindow(storage.ingame_macros or "", {title="Macro editor", description="You can add your custom macros (or any other lua code) here"}, function(text)
    storage.ingame_macros = text
    reload()
  end)
end)
UI.Button("Ingame hotkey editor", function(newText)
  UI.MultilineEditorWindow(storage.ingame_hotkeys or "", {title="Hotkeys editor", description="You can add your custom hotkeys/singlehotkeys here"}, function(text)
    storage.ingame_hotkeys = text
    reload()
  end)
end)
UI.Label("--------------------------------")
for _, scripts in ipairs({storage.ingame_macros, storage.ingame_hotkeys}) do
  if type(scripts) == "string" and scripts:len() > 3 then
    local status, result = pcall(function()
      assert(load(scripts, "ingame_editor"))()
    end)
    if not status then 
      error("Ingame edior error:\n" .. result)
    end
  end
end
UI.Label("--------------------------------")

UI.Separator()

local creatureId = nil;
local stopAttackRequested = false

keepTarget = {
  setTarget = function(_creatureId)
    creatureId = _creatureId
  end,

  stopAttack = function()
    stopAttackRequested = true
  end
}

keepTarget.macro = macro(1, "Hold Target", function()
  if g_game.getFollowingCreature() then
    keepTarget.stopAttack()
  end

  local creature = g_game.getAttackingCreature()

  if creature and creatureId ~= creature:getId() then
    keepTarget.setTarget(creature:getId())
  end

  if creatureId and not creature and not stopAttackRequested then
    local target = getCreatureById(creatureId)
    if target and CaveBot.isOff() then
      attack(target)
    end

  elseif stopAttackRequested then
    creatureId = nil
    g_game.cancelAttack()
    stopAttackRequested = false
  end
end)

onKeyUp(function(keys)
    if keys == "Escape" then
      keepTarget.stopAttack()
    end
  end)
addIcon("keepTarget.macro", {item={id = 2144, count = 1}, text="Hold Target ------ ------ ----- ------"}, function(icon, isOn)
    keepTarget.macro.setOn(isOn)
end)
addIcon("keepTarget.macro", {item={id = 8103, count = 1}}, function(icon, isOn)
     keepTarget.macro.setOn(isOn)
end)


UI.Separator()
UI.Label("Auto equip")

if type(storage.autoEquip) ~= "table" then
  storage.autoEquip = {}
end
for i=1,4 do -- if you want more auto equip panels you can change 4 to higher value
  if not storage.autoEquip[i] then
    storage.autoEquip[i] = {on=false, title="Auto Equip", item1=i == 9 and 3052 or 0, item2=i == 9 and 3089 or 0, slot=i == 1 and 9 or 0}
  end
  UI.TwoItemsAndSlotPanel(storage.autoEquip[i], function(widget, newParams)
    storage.autoEquip[i] = newParams
  end)
end
macro(250, function()
  local containers = g_game.getContainers()
  for index, autoEquip in ipairs(storage.autoEquip) do
    if autoEquip.on then
      local slotItem = getSlot(autoEquip.slot)
      if not slotItem or (slotItem:getId() ~= autoEquip.item1 and slotItem:getId() ~= autoEquip.item2) then
        for _, container in pairs(containers) do
          for __, item in ipairs(container:getItems()) do
            if item:getId() == autoEquip.item1 or item:getId() == autoEquip.item2 then
              g_game.move(item, {x=65535, y=autoEquip.slot, z=0}, item:getCount())
              delay(1000) -- don't call it too often      
              return
            end
          end
        end
      end
    end
  end
end)

UI.Separator()

UI.Label("Usa somente no Target"):setColor("green")
local SD = macro(850, "Sd on Target", function()
    if g_game.isAttacking() then
        usewith(3155, g_game.getAttackingCreature())
    end
end)
addIcon("SD", {item={id = 7465, count = 1}, text="SD"}, function(icon, isOn)
  SD.setOn(isOn)
end)
addIcon("SD", {item={id = 3155, count = 1}}, function(icon, isOn)
  SD.setOn(isOn)
end)
local MegaSD = macro(850, "Mega Sd Target", function()
    if g_game.isAttacking() then
        usewith(3150, g_game.getAttackingCreature())
    end
end)
addIcon("MegaSD", {item={id = 7465, count = 1}, text="Mega SD"}, function(icon, isOn)
  MegaSD.setOn(isOn)
end)
addIcon("MegaSD", {item={id = 3150, count = 1}}, function(icon, isOn)
  MegaSD.setOn(isOn)
end)
UI.Separator()
local frags = 0
UI.Label("Usa sem parar"):setColor("green")
local utito = macro(500, "Exevo Gran Mas Frigo", function()
           say("Exevo Gran Mas Frigo")
end)
local utito = macro(500, "Exevo Gran Mas Tera", function()
           say("Exevo Gran Mas tera")
end)

UI.Separator()

local toggle = macro(10, "mwall step",function() end)

onPlayerPositionChange(function(newPos, oldPos)
    if oldPos.z ~= posz() then return end
    if oldPos then
        local tile = g_map.getTile(oldPos)
        if toggle.isOn() and tile:isWalkable() then
            useWith(3180, tile:getTopUseThing())
        end
    end
end)
addIcon("toggle", {item={id = 7465, count = 1}, text="MW step"}, function(icon, isOn)
  toggle.setOn(isOn)
end)
addIcon("toggle", {item={id = 3180, count = 1}}, function(icon, isOn)
  toggle.setOn(isOn)
end)

local toggle2 = macro(500, "mwall on target",function() end)

onCreaturePositionChange(function(creature, newPos, oldPos)
    if creature == target() or creature == g_game.getFollowingCreature() then
        if oldPos and oldPos.z == posz() then
            local tile2 = g_map.getTile(oldPos)
            if toggle2.isOn() and tile2:isWalkable() then
                useWith(3180, tile2:getTopUseThing())
            end 
        end
    end
end)
addIcon("toggle2", {item={id = 7465, count = 1}, text=" MW on Target ---- ----- ---- -----"}, function(icon, isOn)
  toggle2.setOn(isOn)
end)
addIcon("toggle2", {item={id = 3180, count = 1}}, function(icon, isOn)
  toggle2.setOn(isOn)
end)

local reUseToggle = macro(500, "Click ReUse", "`", function() end)
local excluded = {268, 237, 238, 23373, 266, 236, 239, 7643, 23375, 7642, 23374, 5908, 5942, storage.shovel, storage.rope, storage.machete} 

onUseWith(function(pos, itemId, target, subType)
  if reUseToggle.isOn() and not table.find(excluded, itemId) then
    schedule(50, function()
      item = findItem(itemId)
      if item then
        modules.game_interface.startUseWith(item)
      end
    end)
  end
end)
addIcon("reUseToggle", {item={id = 7465, count = 1}, text="reUse"}, function(icon, isOn)
  reUseToggle.setOn(isOn)
end)
addIcon("reUseToggle", {item={id = 5925, count = 1}}, function(icon, isOn)
  reUseToggle.setOn(isOn)
end)

local m = macro(1000, "AntiRS war", function() end)
onTextMessage(function(mode, text)
	if not m.isOn() then return end
	if not text:lower():find("warning! the murder of") then return end
	frags = frags + 1
	if killsToRs() < 6 or frags > 1 then
		utito.setOff()
	end
end)